C-----------------------------------------------------------------------
      PROGRAM RDMAS
C   READ MAS.DAT(MAS1T.DAT) GENERATED BY RRKM(RRKM1T) AND
C    PRINT E,RHO(E),K(E) TABLE
C ------------------------------------------
C    Jun. 16, 2016  A. MIYOSHI     REV. 0.7
C      1) aligned array sizes of PR(), TEMPV, and CORRAT to mas55c3.f
C         and rrkmth.f
C    Aug.  8, 2011  A. MIYOSHI     REV. 0.6
C     changes made in Rev. 0.6
C      1) changed the energy output
C    Oct.  8, 2009  A. MIYOSHI     REV. 0.5
C     changes made in Rev. 0.5
C      1) modified output precision
C    AUG.  6, 2009  A. MIYOSHI     REV. 0.4
C     changes made in Rev. 0.4
C      1) modified corresponding to the increase of number-of-channels
C         limit in rrknth.f and mas55c3.f.  now 'mas55cm.h' is read in.
C         To increase maxmum number of channels, edit mas55cm.h.
C      2) disabled old code to sum-up k(E)'s.
C    OCT. 26, 2004  A. MIYOSHI     REV. 0.3
C     changes made in Rev. 0.3
C      1) added outputs to rdmas.csv (10) and massum.dat (11)
C    JUNE 27, 1999  A. MIYOSHI     REV. 0.2
C    JUNE 18, 1999  A. MIYOSHI     REV. 0.1
C-----------------------------------------------------------------------
C  NOTES:
C   1) INPUT IS READ FROM STANDARD INPUT AND OUTPUT IS WRITTEN TO
C    STANDARD OUTPUT. EXECUTE AS:
C   %rdmas < mas.dat > rhotab.dat
C    THE OUTPUT DATA CONTAINS THE FOLLOWING COLUMNS
C      E[/cm] rho[cm] k1[s-1] (K2, K3)
C   2) THIS PROGRAM WORKS ONLY FOR MAS.DAT(MAS1T.DAT) GENERATED WITH
C    THE OPTION JAV=0
C-----------------------------------------------------------------------
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INCLUDE 'mas55cm.h'
C ----> Jun. 16, 2016
C     DIMENSION TITLE(20),ALPHAV(10),PR(20),TEMPV(10),CORRAT(10)
      DIMENSION TITLE(20),ALPHAV(10),PR(MXNPRS),TEMPV(MXNTMP),
     .          CORRAT(MXNTMP)
C <---- Jun. 16, 2016
      COMMON /LRGARR/ RHO(NMAX100),R1(NMAX100),R2(NMAX100,MX2CH)
C ----- disabled code to sum-up k(E) (due to channel-limit)
C     COMMON /LRGSUM/ SUMR(NMAX100,4)
      DATA WNKCAL /2.85914D-3/
C
      OPEN(10,FILE='rdmas.csv',STATUS='UNKNOWN')
C ----- disabled code to sum-up k(E) (due to channel-limit)
C     OPEN(11,FILE='massum.dat',STATUS='UNKNOWN')
      READ(5,900) TITLE
      READ(5,*) INC,NCHAN,INCCHK
       NCH2=MAX0(NCHAN,2)-1
      READ(5,*) ERR1,ERR2,ERR3
      READ(5,*) E0
      READ(5,*) NALPHA
      READ(5,*) (ALPHAV(I),I=1,NALPHA)
      READ(5,*) IXV,JXV
      READ(5,*) NP
      READ(5,*) (PR(I),I=1,NP)
      READ(5,*) PALMT
      READ(5,*) JAV
      READ(5,*) NTEMP,(TEMPV(I),I=1,NTEMP)
      READ(5,*) SGMA,WT1,WT2,EPS
      READ(5,*) IOPTHT,IOPTPR
      READ(5,*) NDEGS
      READ(5,*) (RHO(I),I=1,NDEGS)
      DO I=1,NTEMP
        READ(5,*)T,CORRAT(I)
      ENDDO
      READ(5,*) NRATES
      READ(5,*) (R1(I),I=1,NRATES)
      DO I=1,NCH2
        READ(5,*) (R2(II,I),II=1,NRATES)
      ENDDO
C
      DELT=DBLE(FLOAT(INCCHK))
      NREACT=INT(E0/(DELT*WNKCAL))
      NTOP=NREACT+NRATES
      IF (NTOP.NE.NDEGS) WRITE(6,910)
      NTOP=MIN0(NTOP,NDEGS)
      WRITE(6,920) (IC,IC=1,NCHAN)
      WRITE(10,921) (IC,IC=1,NCHAN)
      DO I=1,NTOP
        E=DELT*DBLE(FLOAT(I-1))
        JE=INT(E)
        IF (I.GT.NREACT) THEN
          J=I-NREACT
          WRITE(6,930) JE,RHO(I),R1(J),(R2(J,IC),IC=1,NCHAN-1)
          WRITE(10,931) JE,RHO(I),R1(J),(R2(J,IC),IC=1,NCHAN-1)
         ELSE
          WRITE(6,930) JE,RHO(I),0.0D0,(0.0D0,II=1,NCHAN-1)
          WRITE(10,931) JE,RHO(I),0.0D0,(0.0D0,II=1,NCHAN-1)
        END IF
      ENDDO
C
C ----- disabled code to sum-up k(E) (due to channel-limit)
C     NMSUMR=0
C     IF (NCHAN.EQ.2) THEN
C       NMSUMR=NMSUMR+1
C       DO II=1,NRATES
C         SUMR(II,NMSUMR)=R1(II)+R2(II,1)
C       ENDDO
C     ELSEIF (NCHAN.EQ.3) THEN
C       DO IACH=1,2
C         NMSUMR=NMSUMR+1
C         DO II=1,NRATES
C           SUMR(II,NMSUMR)=R1(II)+R2(II,IACH)
C         ENDDO
C       ENDDO
C       NMSUMR=NMSUMR+1
C       DO II=1,NRATES
C         SUMR(II,NMSUMR)=R2(II,1)+R2(II,2)
C       ENDDO
C       NMSUMR=NMSUMR+1
C       DO II=1,NRATES
C         SUMR(II,NMSUMR)=R1(II)+R2(II,1)+R2(II,2)
C       ENDDO
C     END IF
C     WRITE(11,950) NRATES
C     DO ISUM=1,NMSUMR
C       IF (ISUM.EQ.1) WRITE(11,*) ' [k1+k2]'
C       IF (ISUM.EQ.2) WRITE(11,*) ' [k1+k3]'
C       IF (ISUM.EQ.3) WRITE(11,*) ' [k2+k3]'
C       IF (ISUM.EQ.4) WRITE(11,*) ' [k1+k2+k3]'
C       WRITE(11,955) (SUMR(II,ISUM),II=1,NRATES)
C     ENDDO
C
      CLOSE(10,STATUS='KEEP')
C ----- disabled code to sum-up k(E) (due to channel-limit)
C     CLOSE(11,STATUS='KEEP')
      STOP
C
  900 FORMAT(1X,20A4)
  910 FORMAT(' THE MAS.DAT MAY BE CORRUPTED !')
  920 FORMAT(' E[cm-1] rho[cm]',10('  k',I2,'[s-1]'))
  921 FORMAT('E[cm-1],rho[cm]',10(',k',I2,'[s-1]'))
  930 FORMAT(' ',I6,1P,11E10.3)
  931 FORMAT(I6,1P,11(',',E10.3))
C ----- disabled code to sum-up k(E) (due to channel-limit)
C 950 FORMAT(1X,I4)
C 955 FORMAT(1X,7E10.3)
      END
C
