/*========================================================================
     "numlibChb" - regression to Chebyshev polynomials
      This is a part of "ssumes" -
        Steady-State Unimoluclar Master Equation Solver
             Copyright (c) 2002-2011 by A. Miyoshi, Univ. Tokyo
========================================================================*/

#ifndef _NUMLIBCHB_H_
#define _NUMLIBCHB_H_

#include "numlibBls.h"

/*========================================================================
     Rate coefficients regression to Chebyshev polynomials
========================================================================*/

double cheb(int n, double x);       // Chebyshev polynomial of degree n

struct kDatumTP {
  double k, T, P;
};

struct transDatum {
  double logk, Ttil, Ptil;
};

class chebyTPfit : public basicLinLsSq {
 public:                                       // --- data members ---
  int nParT, nParP;
  double Tmin, Tmax, Pmin, Pmax;
  double invTmin, invTmax, logPmin, logPmax;
  vector<transDatum> tkdat;
  double sdk, madk, maxadk;
  vector<double> parA, stdA;
  vector<vector<double> > corcoefA;
 public:                                   // --- member functions ---
  chebyTPfit();
  chebyTPfit(int npT, int npP, double Ts, double Te, double Ps, double Pe);
  void clear();
  int init(int npT, int npP, double Ts, double Te, double Ps, double Pe);
  int addRateTP(double k, double T, double P);
  int addRateTP(kDatumTP &kd);
  int addRateTParray(vector<double> &k, vector<double> &T,
   vector<double> &P);
  int addRateTParray(vector<kDatumTP> &vkd);
  int addRateTPmatrix(vector<vector<double> > &k,
   vector<double> &T, vector<double> &P);
  int solve();
 private:
  double calfit(double Tt, double Pt);
  double Ttilde(double T);          // convert T to T-tilde
  double Ptilde(double P);          // convert P to P-tilde
};

class chebyRate {
 public:                                       // --- data members ---
  int ready;
  int nParT, nParP;
  double Tmin, Tmax, Pmin, Pmax;
  double invTmin, invTmax, logPmin, logPmax;
  vector<vector<double> > coef;
 public:                                   // --- member functions ---
  chebyRate();
  void clear();
  int init(int npT, int npP, double Ts, double Te, double Ps, double Pe,
   vector<vector<double> > &c);
  double calc(double T, double P);
 private:
  double Ttilde(double T);          // convert T to T-tilde
  double Ptilde(double P);          // convert P to P-tilde
};

#endif

