# ========================================================================
#    Build "ssumes" executables
#    This is a part of "ssumes"
#                   - Steady-State Unimoluclar Master Equation Solver
#            Copyright (c) 2009-2014  by A. Miyoshi, Univ. Tokyo
#                      last edited: Dec.  16, 2014
# ========================================================================

# ----- Operating-System dependent commands and file extensions --------

#RM = rm -f
RM = del
#MV = mv
MV = move
#AR = ar cr 
AR = lib /OUT:
#XO = o
XO = obj
#XA = a
XA = lib

# ----- names of C++ and Fortran compilers and options -----------------
# ----- suggested names of C++ and Fortran compilers
#  GNU compiler (version 4)         .. g++, gfortran
#               (version 3)         .. g++, g77
#  Intel compilers for Linux/MacOS  .. icc, ifort
#                  for Windows      .. icl, ifort
# ----- suggested optimization flags
#  Intel compilers for Windows      .. -O2
#  Others                           .. -O
# ----------------------------------------------------------------------

#CPCMP = g++ -O
#CPCMP = icc -O
CPCMP = icl -O2

#F7CMP = gfortran -O
#F7CMP = g77 -O
#F7CMP = ifort -O
F7CMP = ifort -O2

# ----- names of the LAPACK/BLAS library files -------------------------
#  ----------               (to build a part of LAPACK/BLAS)
#LPKSYR = lapack_dsyevr.$(XA)
#LPKSYE = lapack_dsyev.$(XA)
#LPKSYS = lapack_dsysv.$(XA)
#LPKPOS = lapack_dposv.$(XA)
#  ----------               (to use pre-build LAPACK/BLAS including MKL)
LPKSYR =
LPKSYE =
LPKSYS =
LPKPOS =

# ----- program to be used for linking ---------------------------------
#                           (for other than Intel compilers on Linux)
LNKER = $(CPCMP)
#                           (for Intel compilers on Linux)
#LNKER = $(F7CMP) -nofor_main

# ----- library options to the linker ----------------------------------
#  ----------               (to build a part of LAPACK/BLAS)
#   GNU compiler (gfortran)         .. -lgfortran
#                (g77)              .. -lg2c
#   Intel compilers for Linux       .. -cxxlib
#   Intel compiler for Windows      .. (null)
#  ----------               (to use pre-build LAPACK/BLAS including MKL)
#   BLAS/LAPACK (gfortran-built)    .. -llapack -lblas -lgfortran
#               (g77-built)         .. -llapack -lblas -lg2c
#   intel MKL                       .. (consult the MKL manual and
#                                       examples shown below)
# ----------------------------------------------------------------------

#LLIBS = -lgfortran
#LLIBS = -lg2c
#LLIBS = -cxxlib
#LLIBS =
#LLIBS = -llapack -lblas -lgfortran
#LLIBS = -llapack -lblas -lg2c
#LLIBS = -lmkl_em64t -lguide -lpthread -cxxlib
#LLIBS = -lmkl_lapack -lmkl_em64t -lguide -lpthread -cxxlib
LLIBS = mkl_intel_c.lib mkl_intel_thread.lib mkl_core.lib libiomp5md.lib

# ===== no need to edit below in usual circumstances =====================

LOBJ = ssulibc.$(XO) ssulibb.$(XO) $(LPKSYR) $(LPKPOS) dlsodes.$(XA)
HEAD = ssulibc.h ssulibb.h lapack_dsyevr/wcpp_dsyevr.h \
 lapack_dposv/wcpp_dposv.h dlsodes/wcpp_dlsodes.h
LOBJFC = ssulibb.$(XO) numlibChb.$(XO) numlibBls.$(XO) $(LPKPOS)
HEADFC = ssulibb.h numlibBls.h numlibChb.h lapack_dposv/wcpp_dposv.h
LOBJKC = $(LOBJFC)
HEADKC = $(HEADFC)

all: carate catime diseig dislit distim fitcheb kcheb

carate : carate.$(XO) $(LOBJ)
	$(LNKER) carate.$(XO) $(LOBJ) $(LLIBS) -o carate

catime : catime.$(XO) $(LOBJ)
	$(LNKER) catime.$(XO) $(LOBJ) $(LLIBS) -o catime

diseig : diseig.$(XO) $(LOBJ)
	$(LNKER) diseig.$(XO) $(LOBJ) $(LLIBS) -o diseig

dislit : dislit.$(XO) $(LOBJ)
	$(LNKER) dislit.$(XO) $(LOBJ) $(LLIBS) -o dislit

distim : distim.$(XO) $(LOBJ)
	$(LNKER) distim.$(XO) $(LOBJ) $(LLIBS) -o distim

fitcheb : fitcheb.$(XO) $(LOBJFC)
	$(LNKER) fitcheb.$(XO) $(LOBJFC) $(LLIBS) -o fitcheb

kcheb : kcheb.$(XO) $(LOBJKC)
	$(LNKER) kcheb.$(XO) $(LOBJKC) $(LLIBS) -o kcheb

#dise1w : dise1w.$(XO) $(LOBJ)
#	$(LNKER) dise1w.$(XO) $(LOBJ) $(LLIBS) -o dise1w

#ssCa1w : ssCa1w.$(XO) $(LOBJ)
#	$(LNKER) ssCa1w.$(XO) $(LOBJ) $(LLIBS) -o ssCa1w

#ssDl1w : ssDl1w.$(XO) $(LOBJ)
#	$(LNKER) ssDl1w.$(XO) $(LOBJ) $(LLIBS) -o ssDl1w

#ssDsMw : ssDsMw.$(XO) $(LOBJ)
#	$(LNKER) ssDsMw.$(XO) $(LOBJ) $(LLIBS) -o ssDsMw

#ssDs1w : ssDs1w.$(XO) $(LOBJ)
#	$(LNKER) ssDs1w.$(XO) $(LOBJ) $(LLIBS) -o ssDs1w

carate.$(XO) : carate.cc $(HEAD)
	$(CPCMP) -c carate.cc

catime.$(XO) : catime.cc $(HEAD)
	$(CPCMP) -c catime.cc

diseig.$(XO) : diseig.cc $(HEAD)
	$(CPCMP) -c diseig.cc

dislit.$(XO) : dislit.cc $(HEAD)
	$(CPCMP) -c dislit.cc

distim.$(XO) : distim.cc $(HEAD)
	$(CPCMP) -c distim.cc

fitcheb.$(XO) : fitcheb.cc ssulibb.h $(HEADFC)
	$(CPCMP) -c fitcheb.cc

kcheb.$(XO) : kcheb.cc $(HEADKC)
	$(CPCMP) -c kcheb.cc

#dise1w.$(XO) : dise1w.cc $(HEAD)
#	$(CPCMP) -c dise1w.cc

#ssCa1w.$(XO) : ssCa1w.cc $(HEAD)
#	$(CPCMP) -c ssCa1w.cc

#ssDl1w.$(XO) : ssDl1w.cc $(HEAD)
#	$(CPCMP) -c ssDl1w.cc

#ssDsMw.$(XO) : ssDsMw.cc $(HEAD)
#	$(CPCMP) -c ssDsMw.cc

#ssDs1w.$(XO) : ssDs1w.cc $(HEAD)
#	$(CPCMP) -c ssDs1w.cc

ssulibc.$(XO) : ssulibc.cc $(HEAD)
	$(CPCMP) -c ssulibc.cc

ssulibb.$(XO) : ssulibb.cc ssulibb.h
	$(CPCMP) -c ssulibb.cc

numlibChb.$(XO) : numlibChb.cc $(HEADFC)
	$(CPCMP) -c numlibChb.cc

numlibBls.$(XO) : numlibBls.cc numlibBls.h lapack_dposv/wcpp_dposv.h
	$(CPCMP) -c numlibBls.cc

lapack_dsyevr.$(XA) : lapack_dsyevr/*.f
	cd lapack_dsyevr && \
	$(F7CMP) -c *.f && \
	$(AR)../$(LPKSYR) *.$(XO) && \
	$(RM) *.$(XO) && \
	cd ..

lapack_dposv.$(XA) : lapack_dposv/*.f
	cd lapack_dposv && \
	$(F7CMP) -c *.f && \
	$(AR)../$(LPKPOS) *.$(XO) && \
	$(RM) *.$(XO) && \
	cd ..

dlsodes.$(XA) : dlsodes/*.f
	cd dlsodes && \
	$(F7CMP) -c *.f && \
	$(AR)../dlsodes.$(XA) *.$(XO) && \
	$(RM) *.$(XO) && \
	cd ..

clean:
	$(RM) *.$(XO) *.$(XA)

