/* ---------------------------------------------------------------------
     C++ wrapper for LAPACK DSYEVR
       * also includes implementation (wrapper itself)
             Copyright (c) 2005-2009  by A. Miyoshi, Univ. Tokyo
                         created: Sept.  8, 2005
                          edited: Nov.   8, 2009
                     last edited: May   23, 2010
--------------------------------------------------------------------- */

#ifndef _WCPP_DSYEVR_H_
#define _WCPP_DSYEVR_H_

#if defined (_WIN32) && ! defined (__MINGW32__)
#define ENT_DSYEVR DSYEVR
#else
#define ENT_DSYEVR dsyevr_
#endif

extern "C" {
  void ENT_DSYEVR(char &jobz, char &range, char &uplo, int &n, double **a,
   int &lda, double &vl, double &vu, int &il, int &iu, double &abstol,
   int &m, double *w, double **z, int &ldz, int *isuppz, double *work,
   int &lwork, int *iwork, int &liwork, int &info);
}

int lapack_dsyevr(char jobz, char range, char uplo, int n, double **a,
 int lda, double vl, double vu, int il, int iu, double abstol,
 int &m, double *w, double **z, int ldz, int *isuppz, double *work,
 int lwork, int *iwork, int liwork) {
  int info;
  ENT_DSYEVR(jobz, range, uplo, n, a, lda, vl, vu, il, iu, abstol,
   m, w, z, ldz, isuppz, work, lwork, iwork, liwork, info);
  return info;
}

#endif

