/* ---------------------------------------------------------------------
     C++ wrapper for LAPACK DPOSV, DPOTRI, DPOTRF, and DPOTRS
       * also includes implementation (wrapper itself)
             Copyright (c) 2003-2009  by A. Miyoshi, Univ. Tokyo
                         created: Feb.   7, 2003 (cwrap_lapack)
                          edited: Sept. 21, 2009
                     last edited: June   6, 2011
--------------------------------------------------------------------- */

#ifndef _WCPP_DPOSV_H_
#define _WCPP_DPOSV_H_

#if defined (_WIN32) && ! defined (__MINGW32__)
#define ENT_DPOSV DPOSV
#define ENT_DPOTRI DPOTRI
#define ENT_DPOTRF DPOTRF
#define ENT_DPOTRS DPOTRS
#else
#define ENT_DPOSV dposv_
#define ENT_DPOTRI dpotri_
#define ENT_DPOTRF dpotrf_
#define ENT_DPOTRS dpotrs_
#endif

extern "C" {
  void ENT_DPOSV(char &uplo, int &n, int &nrhs, double **a, int &lda,
   double **b, int &ldb, int &info);
  void ENT_DPOTRI(char &uplo, int &n, double **a, int &lda, int &info);
  void ENT_DPOTRF(char &uplo, int &n, double **a, int &lda, int &info);
  void ENT_DPOTRS(char &uplo, int &n, int &nrhs, double **a, int &lda,
   double **b, int &ldb, int &info);
}

int lapack_dposv(char uplo, int n, int nrhs, double **a, int lda,
 double **b, int ldb) {
  int info;
  ENT_DPOSV(uplo, n, nrhs, a, lda, b, ldb, info);
  return info;
}

int lapack_dpotri(char uplo, int n, double **a, int lda) {
  int info;
  ENT_DPOTRI(uplo, n, a, lda, info);
  return info;
}

int lapack_dpotrf(char uplo, int n, double **a, int lda) {
  int info;
  ENT_DPOTRF(uplo, n, a, lda, info);
  return info;
}

int lapack_dpotrs(char uplo, int n, int nrhs, double **a, int lda,
 double **b, int ldb) {
  int info;
  ENT_DPOTRS(uplo, n, nrhs, a, lda, b, ldb, info);
  return info;
}

#endif

