/* ---------------------------------------------------------------------
     C++ wrapper for DLSODES
       * also includes implementation (wrapper itself)
       * this is the special version for use with umolProb class
             Copyright (c) 2003-2011  by A. Miyoshi, Univ. Tokyo
                         created: May   30, 2011
--------------------------------------------------------------------- */

#ifndef _WCPP_DLSODES_H_
#define _WCPP_DLSODES_H_

#if defined (_WIN32) && ! defined (__MINGW32__)
#define ENT_DLSODES DLSODES
#else
#define ENT_DLSODES dlsodes_
#endif

extern "C" {
  void ENT_DLSODES(void (*f)(int *, double *, double *, double *),
   int &neq, double *y, double &t, double &tout, int &itol,
   double &rtol, double *atol, int &itask, int &istate, int &iopt,
   double *rwork, int &lrw, int *iwork, int &liw,
   void (*jac)(int *, double *, double *, int *, int *, int *, double *),
   int &mf);
}

umolProb *u;

void Fwrap(int *neq, double *t, double *y, double *ydot) {
  u->lsdF(*neq, *t, y, ydot);
}

void JACwrap(int *neq, double *t, double *y, int *j, int *ian, int *jan,
             double *pdj) {
  u->lsdsJAC(*neq, *t, y, *j, ian, jan, pdj);
}

void cpp_dlsodes(umolProb *ump, int neq, double *y, double &t, double tout,
 int itol, double &rtol, double *atol, int itask, int &istate, int iopt,
 double *rwork, int lrw, int *iwork, int liw, int mf) {
  u = ump;
  ENT_DLSODES(&Fwrap, neq, y, t, tout, itol, rtol, atol, itask,
   istate, iopt, rwork, lrw, iwork, liw, &JACwrap, mf);
}

#endif

