/* ======================================================================
     "numlibBls" - Basic linear least squares library
             Copyright (c) 2002-2009  by A. Miyoshi, Univ. Tokyo
 ====================================================================== */

#ifndef _NUMLIBBLS_H_
#define _NUMLIBBLS_H_

#include <iostream>
#include <fstream>
#include <sstream>
#include <iomanip>
#include <string>
#include <vector>
#include <set>
#include <map>
#include <algorithm>
#include <cctype>
#include <cstring>
#include <cstdlib>
#include <cmath>
using namespace std;

#ifndef true
#define true (-1)
#endif
#ifndef false
#define false 0
#endif
#ifndef M_PI
#define	M_PI    3.14159265358979323846
#endif
#ifndef NORM
#define NORM    0
#endif
#ifndef ERRE
#define ERRE    1
#endif

/* ===== basic Linear Least Squares Class ============================= */

class basicLinLsSq {
 public:
  enum { MXNPAR = 400 }; // maximum number of fitting parameters
 protected:
  int nPars;             // number of parameters
  int nMeas;             // number of 'measurement' points
  enum erract { INIT, DADD, SOLV };
  enum errcode { NOT_init, LRG_nPars, SML_nPars, SMLN_x,
                 SMLN_meas, meas_SMLTp,
                 POSVpar, POSVfail, POTRIpar, POTRIfail };
 private:
  vector<vector<double> > sumXX;
  vector<double> sumYX;
  double sumYY;
  double a[MXNPAR][MXNPAR], b[1][MXNPAR];
 public:
  basicLinLsSq();
  basicLinLsSq(int npar);
  void clear();
  int init(int npar);
  int addDatumW(double y, vector<double> &x, double w);
  int addDatum(double y, vector<double> &x);
  int putDataW(int n, vector<double> &y, vector<vector<double> > &x,
   vector<double> &w);
  int putData(int n, vector<double> &y, vector<vector<double> > &x);
  int solve_blls(vector<double> &mlp, vector<double> &sdp,
   vector<vector<double> > &pcc, double &sdy);
 protected:
  void errmsg(erract era, errcode erc);
};

#endif

