# ========================================================================
#     Build "ssumes" (Steady-State Unimoluclar Master Equation Solver)
#       executables
#            Copyright (c) 2009       by A. Miyoshi, Univ. Tokyo
# ========================================================================

# ----- names of C++ and Fortran compilers and options -----------------
# ----- suggested names of C++ and Fortran compilers
#  GNU compiler (Linux, Cygwin)     .. g++, g77
#               (Djgpp)             .. gpp, g77
#  Intel compilers for Linus        .. icc, ifort
#                  for Windows      .. icl, ifort
#  Unix (Solaris)                   .. CC,  f77
# ----- suggested optimization flags
#  Intel compilers for Windows      .. -O2
#  Others                           .. -O
# ----------------------------------------------------------------------

#CPCMP = g++ -O
#CPCMP = gpp -O
CPCMP = icc -O
#CPCMP = icl -O2
#CPCMP = CC -O

#F7CMP = g77 -O
F7CMP = ifort -O
#F7CMP = ifort -O2
#F7CMP = f77 -O

# ----- Operating System dependent -------------------------------------

RM = rm -f
#RM = del
XO = o
#XO = obj
XA = a
#XA = lib

# ----- names of the LAPACK/BLAS library files -------------------------
#  ----------               (to build a part of LAPACK/BLAS)
#LPKSYR = lapack_dsyevr.$(XA)
#LPKSYE = lapack_dsyev.$(XA)
#LPKSYS = lapack_dsysv.$(XA)
#LPKPOS = lapack_dposv.$(XA)
#  ----------               (to use pre-build LAPACK/BLAS including MKL)
LPKSYR =
LPKSYE =
LPKSYS =
LPKPOS =

# ----- program to be used for linking ---------------------------------
#                           (for other than Intel compilers on Linux)
#LNKER = $(CPCMP) -lifcore
#                           (for Intel compilers on Linux)
LNKER = $(F7CMP) -nofor_main

# ----- library options to the linker ----------------------------------
#  ----------               (to build a part of LAPACK/BLAS)
#   GNU compiler                    .. -lg2c
#   Intel compilers for Linux  (8)  .. -lcprts
#   Intel compilers for Linux (10)  .. -cxxlib
#   Intel compiler for Windows (8)  .. (null)
#   Unix (Solaris)                  .. -lfsu -lsunmath
#  ----------               (to use pre-build LAPACK/BLAS including MKL)
#   linux g77-built BLAS/LAPACK     .. -llapack -lblas -lg2c
#   intel MKL                       .. (consult the MKL manual and
#                                       examples shown below)
# ----------------------------------------------------------------------

#LLIBS = -lg2c
#LLIBS = -lcprts
#LLIBS = -cxxlib
#LLIBS =
#LLIBS = -lfsu -lsunmath
#LLIBS = -llapack -lblas -lg2c
LLIBS = /opt/intel/mkl/8.0/lib/64/libmkl_lapack.a /opt/intel/mkl/8.0/lib/64/libmkl_ipf.a -lguide -lpthread -lcprts
#LLIBS = -lmkl_em64t -lguide -lpthread -cxxlib
#LLIBS = -lmkl_lapack -lmkl_em64t -lguide -lpthread -cxxlib

# ===== no need to edit below in usual circumstances =====================

LOBJ = ssulibc.$(XO) ssulibb.$(XO) $(LPKSYR) $(LPKSYE) $(LPKSYS)
HEAD = ssulibc.h ssulibb.h lapack_dsyevr/wcpp_dsyevr.h \
 lapack_dsyev/wcpp_dsyev.h lapack_dsysv/wcpp_dsysv.h
LOBJFC = ssulibb.$(XO) numlibChb.$(XO) numlibBls.$(XO) $(LPKPOS)
HEADFC = numlibBls.h numlibChb.h lapack_dposv/wcpp_dposv.h

all: carate diseig dislit fitcheb

carate : carate.$(XO) $(LOBJ)
	$(LNKER) carate.$(XO) $(LOBJ) $(LLIBS) -o carate

diseig : diseig.$(XO) $(LOBJ)
	$(LNKER) diseig.$(XO) $(LOBJ) $(LLIBS) -o diseig

dislit : dislit.$(XO) $(LOBJ)
	$(LNKER) dislit.$(XO) $(LOBJ) $(LLIBS) -o dislit

fitcheb : fitcheb.$(XO) $(LOBJFC)
	$(LNKER) fitcheb.$(XO) $(LOBJFC) $(LLIBS) -o fitcheb

#dise1w : dise1w.$(XO) $(LOBJ)
#	$(LNKER) dise1w.$(XO) $(LOBJ) $(LLIBS) -o dise1w

#ssCa1w : ssCa1w.$(XO) $(LOBJ)
#	$(LNKER) ssCa1w.$(XO) $(LOBJ) $(LLIBS) -o ssCa1w

#ssDl1w : ssDl1w.$(XO) $(LOBJ)
#	$(LNKER) ssDl1w.$(XO) $(LOBJ) $(LLIBS) -o ssDl1w

#ssDsMw : ssDsMw.$(XO) $(LOBJ)
#	$(LNKER) ssDsMw.$(XO) $(LOBJ) $(LLIBS) -o ssDsMw

#ssDs1w : ssDs1w.$(XO) $(LOBJ)
#	$(LNKER) ssDs1w.$(XO) $(LOBJ) $(LLIBS) -o ssDs1w

carate.$(XO) : carate.cc $(HEAD)
	$(CPCMP) -c carate.cc

diseig.$(XO) : diseig.cc $(HEAD)
	$(CPCMP) -c diseig.cc

dislit.$(XO) : dislit.cc $(HEAD)
	$(CPCMP) -c dislit.cc

fitcheb.$(XO) : fitcheb.cc ssulibb.h $(HEADFC)
	$(CPCMP) -c fitcheb.cc

#dise1w.$(XO) : dise1w.cc $(HEAD)
#	$(CPCMP) -c dise1w.cc

#ssCa1w.$(XO) : ssCa1w.cc $(HEAD)
#	$(CPCMP) -c ssCa1w.cc

#ssDl1w.$(XO) : ssDl1w.cc $(HEAD)
#	$(CPCMP) -c ssDl1w.cc

#ssDsMw.$(XO) : ssDsMw.cc $(HEAD)
#	$(CPCMP) -c ssDsMw.cc

#ssDs1w.$(XO) : ssDs1w.cc $(HEAD)
#	$(CPCMP) -c ssDs1w.cc

ssulibc.$(XO) : ssulibc.cc $(HEAD)
	$(CPCMP) -c ssulibc.cc

ssulibb.$(XO) : ssulibb.cc ssulibb.h
	$(CPCMP) -c ssulibb.cc

numlibChb.$(XO) : numlibChb.cc $(HEADFC)
	$(CPCMP) -c numlibChb.cc

numlibBls.$(XO) : numlibBls.cc numlibBls.h lapack_dposv/wcpp_dposv.h
	$(CPCMP) -c numlibBls.cc

lapack_dsyevr.a : lapack_dsyevr/*.f
	cd lapack_dsyevr; \
	$(F7CMP) -c *.f; \
	ar cr ../$(LPKSYR) *.$(XO); \
	$(RM) *.$(XO); \
	cd ..

lapack_dsyevr.lib : lapack_dsyevr/*.f
	cd lapack_dsyevr
	$(F7CMP) -c *.f
	lib /OUT:..\$(LPKSYR) *.$(XO)
	$(RM) *.$(XO)
	cd ..

lapack_dsyev.a : lapack_dsyev/*.f
	cd lapack_dsyev; \
	$(F7CMP) -c *.f; \
	ar cr ../$(LPKSYE) *.$(XO); \
	$(RM) *.$(XO); \
	cd ..

lapack_dsyev.lib : lapack_dsyev/*.f
	cd lapack_dsyev
	$(F7CMP) -c *.f
	lib /OUT:..\$(LPKSYE) *.$(XO)
	$(RM) *.$(XO)
	cd ..

lapack_dsysv.a : lapack_dsysv/*.f
	cd lapack_dsysv; \
	$(F7CMP) -c *.f; \
	ar cr ../$(LPKSYS) *.$(XO); \
	$(RM) *.$(XO); \
	cd ..

lapack_dsysv.lib : lapack_dsysv/*.f
	cd lapack_dsysv
	$(F7CMP) -c *.f
	lib /OUT:..\$(LPKSYS) *.$(XO)
	$(RM) *.$(XO)
	cd ..

lapack_dposv.a : lapack_dposv/*.f
	cd lapack_dposv; \
	$(F7CMP) -c *.f; \
	ar cr ../$(LPKPOS) *.$(XO); \
	$(RM) *.$(XO); \
	cd ..

lapack_dposv.lib : lapack_dposv/*.f
	cd lapack_dposv
	$(F7CMP) -c *.f
	lib /OUT:..\$(LPKPOS) *.$(XO)
	$(RM) *.$(XO)
	cd ..

clean:
	$(RM) *.$(XO) *.$(XA)

