/* ---------------------------------------------------------------------
     C wrapper for LAPACK DSYSV
       * also includes implementation (wrapper itself)
             Copyright (c) 2003-2009  by A. Miyoshi, Univ. Tokyo
                         created: Feb.   7, 2003 (cwrap_lapack)
                     last edited: Sept. 27, 2009
--------------------------------------------------------------------- */

#ifndef _WC_DSYSV_H_
#define _WC_DSYSV_H_

#ifdef _WIN32
#define ENT_DSYSV DSYSV
#else
#define ENT_DSYSV dsysv_
#endif

extern
  void ENT_DSYSV(char *uplo, int *n, int *nrhs, double **a, int *lda,
   int *ipiv, double **b, int *ldb, double *work, int *lwork, int *info);

int lapack_dsysv(char uplo, int n, int nrhs, double **a, int lda,
 int *ipiv, double **b, int ldb, double *work, int lwork) {
  int info;
  ENT_DSYSV(&uplo, &n, &nrhs, a, &lda, ipiv, b, &ldb, work, &lwork, &info);
  return info;
}

#endif

