/* ---------------------------------------------------------------------
     C wrapper for LAPACK DSYEV
       * also includes implementation (wrapper itself)
             Copyright (c) 2005-2009  by A. Miyoshi, Univ. Tokyo
                         created: Sept.  8, 2005
                     last edited: Sept. 21, 2009
--------------------------------------------------------------------- */

#ifndef _WC_DSYEV_H_
#define _WC_DSYEV_H_

#ifdef _WIN32
#define ENT_DSYEV DSYEV
#else
#define ENT_DSYEV dsyev_
#endif

extern
  void ENT_DSYEV(char *jobz, char *uplo, int *n, double **a, int *lda,
   double *w, double *work, int *lwork, int *info);

int lapack_dsyev(char jobz, char uplo, int n, double **a, int lda,
 double *w, double *work, int lwork) {
  int info;
  ENT_DSYEV(&jobz, &uplo, &n, a, &lda, w, work, &lwork, &info);
  return info;
}

#endif

