/* ---------------------------------------------------------------------
     C++ wrapper for LAPACK DPOSV & DPOTRI
       * also includes implementation (wrapper itself)
             Copyright (c) 2003-2009  by A. Miyoshi, Univ. Tokyo
                         created: Feb.   7, 2003 (cwrap_lapack)
                     last edited: Sept. 21, 2009
--------------------------------------------------------------------- */

#ifndef _WCPP_DPOSV_H_
#define _WCPP_DPOSV_H_

#ifdef _WIN32
#define ENT_DPOSV DPOSV
#define ENT_DPOTRI DPOTRI
#else
#define ENT_DPOSV dposv_
#define ENT_DPOTRI dpotri_
#endif

extern "C" {
  void ENT_DPOSV(char &uplo, int &n, int &nrhs, double **a, int &lda,
   double **b, int &ldb, int &info);
  void ENT_DPOTRI(char &uplo, int &n, double **a, int &lda, int &info);
}

int lapack_dposv(char uplo, int n, int nrhs, double **a, int lda,
 double **b, int ldb) {
  int info;
  ENT_DPOSV(uplo, n, nrhs, a, lda, b, ldb, info);
  return info;
}

int lapack_dpotri(char uplo, int n, double **a, int lda) {
  int info;
  ENT_DPOTRI(uplo, n, a, lda, info);
  return info;
}

#endif

